/*
Sprawdzajac Panow program mialem mieszane uczucia. Z jednej strony wykazali sie
Panowie doskonala znajomoscia zagadnien omawianych w trakcie zajec.
widac, ze lubia Panowie programowac i czerpia z tego przyjemnosc.
Program dziala bardzo dobrze i jest bardzo uniwersalny.
Z drugiej jednak strony program nie jest zgodny ze specyfikacja.
Chcialbym zwrocic Panom uwage na fakt, ze ze wzgledu
na idee, w programowaniu obiektowym trzymanie sie specyfikacji jest elementem
bardzo waznym. Rozwazmy taka sytuacje: jest dwoch programistow. Oboje dostaja
specyfikacje klasy wektor. Jest jednak jedna roznica. Jeden z programistow
oporogramowuje klase wektor, drugi ma wykorzystac gotowa klase w klasach
implementowanych przez siebie. Nie trudno sobie wyobrazic co sie stanie, gdy
programista klasy wektor nie bedzie sie trzymal specyfikacji.

ocena: 5.0
*/


#include <math.h>
#include <conio.h>
#include <stdio.h>
#include <iostream.h>
#include <exception>
#include <stdlib.h>

//version info
const char name[20] = "Program 001";
const int version = 1;
const int subversion = 1;

const dl_max = 15;

class wiktor{
    private:
        int **wektor;
        int *dlugosc;
        int ilosc;

        int **temp_w;
        int *temp_d;

    public:
        wiktor() {

            wektor = NULL;

// nie ma potrzeby pisania "klasa::zmienna" wystarczy "zmienna", np. ilosc = 0;
            wiktor::ilosc = 0;
            wiktor::dlugosc = new int[wiktor::ilosc+1];
            wiktor::dlugosc[wiktor::ilosc] = 1;

            wektor = new int*[wiktor::ilosc+1];
            wektor[wiktor::ilosc] = new int[wiktor::dlugosc[wiktor::ilosc]+1];
            wektor[wiktor::ilosc][0] = 999;
        }
        ~wiktor() {
            delete[] wiktor::dlugosc;
            delete[] wiktor::wektor;
        }

        int wiktor::wyswietl() {

            if ( !wiktor::ilosc ) {
                cout << "Brak zdefiniowanych wektorow!" << endl;
                return 1;
            }
            for (int i = 1; i <= wiktor::ilosc; i++) {
                cout << "wektor " << i << ": " ;
                for (int j=0; j < wiktor::dlugosc[i]; j++) {
                    cout << "[" << wiktor::wektor[i][j] << "] ";
                }
                cout << endl;
            }
            return 0;

        }

        int wiktor::dodaj(int dlugosc) {

            temp_w = new int*[wiktor::ilosc+1];
            for (int i = 0; i <= wiktor::ilosc; i++) {
                temp_w[i] = new int[wiktor::dlugosc[i]+1];
            }

            for (int i = 0; i <= wiktor::ilosc; i++) {
                for (int j = 0; j < wiktor::dlugosc[i]; j++) {
                    wiktor::temp_w[i][j] = wiktor::wektor[i][j];
                }
            }

            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc; i++) { cout << "{wektor " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::wektor[i][j] << "]"; } cout << endl; }
            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc; i++) { cout << "{temp " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::temp_w[i][j] << "]"; } cout << endl; }

            delete[] wiktor::wektor;

            wiktor::temp_d = new int[wiktor::ilosc+1];

            for (int i = 0; i <= wiktor::ilosc; i++) {
                wiktor::temp_d[i] = wiktor::dlugosc[i];
                //DEBUG_OUTPUT cout << "{" << wiktor::temp_d[i] << "|" << wiktor::dlugosc[i] << "}";
            }

            delete[] wiktor::dlugosc;

            wiktor::ilosc++;
            wiktor::dlugosc = new int[wiktor::ilosc+1];

            for (int i = 0; i <= wiktor::ilosc-1; i++) {
                wiktor::dlugosc[i] = wiktor::temp_d[i];
                //DEBUG_OUTPUT cout << "{" << wiktor::temp_d[i] << "|" << wiktor::dlugosc[i] << "}";
            }
            wiktor::dlugosc[wiktor::ilosc] = dlugosc;
            //DEBUG_OUTPUT cout << "{" << wiktor::dlugosc[wiktor::ilosc] << "}";

            wektor = new int*[wiktor::ilosc+1];
            for (int i = 0; i <= wiktor::ilosc; i++) {
                wiktor::wektor[i] = new int[wiktor::dlugosc[i]+1];
            }

            for (int i = 0; i < wiktor::ilosc; i++) {
                for (int j = 0; j < wiktor::dlugosc[i]; j++) {
                    wiktor::wektor[i][j] = wiktor::temp_w[i][j];
                }
            }
            for (int i = 0; i < wiktor::dlugosc[wiktor::ilosc]; i++)
                wektor[wiktor::ilosc][i] = (10 * wiktor::ilosc + i);

            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc-1; i++) { cout << "{te " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::temp_w[i][j] << "]"; } cout << endl; }
            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc; i++) { cout << "{we " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::wektor[i][j] << "]"; } cout << endl; }

            delete[] wiktor::temp_w;

            return 0;
        }

        int wiktor::wymaz(int ktory) {

            if (ktory > wiktor::ilosc)
            return 1;

            temp_w = new int*[wiktor::ilosc+1];
            for (int i = 0; i <= wiktor::ilosc; i++) {
                temp_w[i] = new int[wiktor::dlugosc[i]+1];
            }

            for (int i = 0; i <= wiktor::ilosc; i++) {
                for (int j = 0; j < wiktor::dlugosc[i]; j++) {
                    wiktor::temp_w[i][j] = wiktor::wektor[i][j];
                }
            }

            delete[] wiktor::wektor;
            wiktor::dlugosc[ktory] = 0;
            wektor = new int*[wiktor::ilosc+1];
            for (int i = 0; i <= wiktor::ilosc; i++) {
                wiktor::wektor[i] = new int[wiktor::dlugosc[i]+1];
            }

            for (int i = 0; i <= wiktor::ilosc; i++) {
                for (int j = 0; j < wiktor::dlugosc[i]; j++) {
                    wiktor::wektor[i][j] = wiktor::temp_w[i][j];
                }
            }

            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc; i++) { cout << "{te " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::temp_w[i][j] << "]"; } cout << endl; }
            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc; i++) { cout << "{we " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::wektor[i][j] << "]"; } cout << endl; }

            delete[] wiktor::temp_w;

            return 0;
        }

        int wiktor::zmien_rozmiar(int ktory_wektor, int rozmiar) {

            if (ktory_wektor > wiktor::ilosc)
            return 1;

            int stary =  wiktor::dlugosc[ktory_wektor];

            temp_w = new int*[wiktor::ilosc+1];
            for (int i = 0; i <= wiktor::ilosc; i++) {
                temp_w[i] = new int[wiktor::dlugosc[i]+1];
            }

            for (int i = 0; i <= wiktor::ilosc; i++) {
                for (int j = 0; j < wiktor::dlugosc[i]; j++) {
                    wiktor::temp_w[i][j] = wiktor::wektor[i][j];
                }
            }

            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc; i++) { cout << "{wektor " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::wektor[i][j] << "]"; } cout << endl; }
            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc; i++) { cout << "{temp " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::temp_w[i][j] << "]"; } cout << endl; }

            delete[] wiktor::wektor;

            wiktor::dlugosc[ktory_wektor] = rozmiar;

            wektor = new int*[wiktor::ilosc+1];
            for (int i = 0; i <= wiktor::ilosc; i++) {
                wiktor::wektor[i] = new int[wiktor::dlugosc[i]+1];
            }

            for (int i = 0; i <= wiktor::ilosc; i++) {
                for (int j = 0; j < wiktor::dlugosc[i]; j++) {
                    wiktor::wektor[i][j] = wiktor::temp_w[i][j];
                }
            }

            if (stary < rozmiar) {
                for (int i = stary; i < rozmiar; i++) {
                    wiktor::wektor[ktory_wektor][i] = wiktor::wektor[ktory_wektor][i - 1] + 1;
                }
            }

            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc-1; i++) { cout << "{te " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::temp_w[i][j] << "]"; } cout << endl; }
            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc; i++) { cout << "{we " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::wektor[i][j] << "]"; } cout << endl; }

            delete wiktor::temp_w;

            return 0;
        }
        int wiktor::usun(int ktory) {

            if (ktory > wiktor::ilosc && ktory < 1)
            return 1;

            temp_w = new int*[wiktor::ilosc+1];
            for (int i = 0, k = 0; i <= wiktor::ilosc; i++) {
                if (i == ktory) {
                    k++;
                }
                else {
                    temp_w[i - k] = new int[wiktor::dlugosc[i]+1];
                }
            }

            for (int i = 0, k = 0; i <= wiktor::ilosc; i++) {
                if (i == ktory) {
                    k++;
                }
                else {
                    for (int j = 0; j < wiktor::dlugosc[i]; j++) {
                        wiktor::temp_w[i - k][j] = wiktor::wektor[i][j];
                    }
                }
            }

            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc; i++) { cout << "{wektor " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::wektor[i][j] << "]"; } cout << endl; }
            //DEBUG_OUTPUT for (int i = 0; i < wiktor::ilosc; i++) { cout << "{temp " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::temp_w[i][j] << "]"; } cout << endl; }

            delete[] wiktor::wektor;

            wiktor::temp_d = new int[wiktor::ilosc+1];

            for (int i = 0, k = 0; i <= wiktor::ilosc; i++) {
                if (i == ktory) {
                    k++;
                }
                else {
                    wiktor::temp_d[i - k] = wiktor::dlugosc[i];
                }
                //DEBUG_OUTPUT cout << "{{" << wiktor::temp_d[i] << "|" << wiktor::dlugosc[i] << "}}";
            }

            delete[] wiktor::dlugosc;

            wiktor::ilosc--;
            wiktor::dlugosc = new int[wiktor::ilosc+1];
            //DEBUG_OUTPUT cout << endl;
            for (int i = 0; i <= wiktor::ilosc; i++) {
                wiktor::dlugosc[i] = wiktor::temp_d[i];
                //DEBUG_OUTPUT cout << "{" << wiktor::temp_d[i] << "|" << wiktor::dlugosc[i] << "}";
            }
            //DEBUG_OUTPUT cout << "{" << wiktor::ilosc << "|" << wiktor::dlugosc[wiktor::ilosc] << "}";
            //DEBUG_OUTPUT cout << endl;

            wektor = new int*[wiktor::ilosc+1];
            for (int i = 0; i <= wiktor::ilosc; i++) {
                wiktor::wektor[i] = new int[wiktor::dlugosc[i]+1];
            }

            for (int i = 0; i <= wiktor::ilosc; i++) {
                for (int j = 0; j < wiktor::dlugosc[i]; j++) {
                    wiktor::wektor[i][j] = wiktor::temp_w[i][j];
                }
            }

            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc; i++) { cout << "{te " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::temp_w[i][j] << "]"; } cout << endl; }
            //DEBUG_OUTPUT for (int i = 0; i <= wiktor::ilosc; i++) { cout << "{we " << i << "}"; for (int j=0; j < wiktor::dlugosc[i]; j++) { cout << "[" << wiktor::wektor[i][j] << "]"; } cout << endl; }

            delete[] wiktor::temp_w;

            return 0;
        }


        int wiktor::zwroc_rozmiar(int ktory_wektor) {

            if (ktory_wektor > wiktor::ilosc && ktory_wektor < 1)
            return 0;

            return wiktor::dlugosc[ktory_wektor];

        }

        int wiktor::zwroc_element(int ktory_wektor, int ktory_element) {

            if ( !ktory_element < wiktor::dlugosc[ktory_wektor] || !ktory_wektor <= wiktor::ilosc)
                throw 1;


            return wiktor::wektor[ktory_wektor][ktory_element];
        }

        int wiktor::wpisz_element(int ktory_wektor, int ktory_element, int wartosc) {

            if ( ktory_element >= wiktor::dlugosc[ktory_wektor] || ktory_wektor > wiktor::ilosc) {
                return 1;
            }
            else {

                wiktor::wektor[ktory_wektor][ktory_element] = wartosc;
                return 0;
            }
        }

        int wiktor::razy_skalar(int ktory, int ile) {


            if ( ktory > wiktor::ilosc) {
                return 1;
            }
            else {

             for (int i = 0;  i < wiktor::dlugosc[ktory]; i++)
                wiktor::wektor[ktory][i]*=ile;

            return 0;
            }

        }

        int wiktor::dodaj_dwa(int pierwszy, int drugi, bool nowy){

            if ( pierwszy > wiktor::ilosc || drugi > wiktor::ilosc ) {
                return 1;
            }
            else {
                if (nowy) {
                    wiktor::dodaj(wiktor::dlugosc[pierwszy]);
                    for (int i = 0; i < min(wiktor::dlugosc[pierwszy],wiktor::dlugosc[drugi]); i++){
                        wiktor::wektor[wiktor::ilosc][i] = wiktor::wektor[pierwszy][i] + wiktor::wektor[drugi][i];
                    }
                    for (int i = min(wiktor::dlugosc[pierwszy],wiktor::dlugosc[drugi]); i <  wiktor::dlugosc[pierwszy]; i++) {
                        wiktor::wektor[wiktor::ilosc][i] = wiktor::wektor[pierwszy][i];
                    }
                }
                else {
                    for (int i = 0; i < min(wiktor::dlugosc[pierwszy],wiktor::dlugosc[drugi]); i++){
                        wiktor::wektor[pierwszy][i] = wiktor::wektor[pierwszy][i] + wiktor::wektor[drugi][i];
                    }
                }
                return 0;
            }
        }
        int wiktor::iloczyn_ska(int pierwszy, int drugi){

            if ( pierwszy > wiktor::ilosc || drugi > wiktor::ilosc || wiktor::dlugosc[pierwszy] != wiktor::dlugosc[drugi]) {
                throw 1;
            }
                float iloczyn = 0;

                for (int i = 0; i < min(wiktor::dlugosc[pierwszy],wiktor::dlugosc[drugi]); i++){
                    iloczyn += wiktor::wektor[pierwszy][i] * wiktor::wektor[drugi][i];
                }

                return iloczyn;
        }
        int wiktor::odejmij_dwa(int pierwszy, int drugi, bool nowy){

            if ( pierwszy > wiktor::ilosc || drugi > wiktor::ilosc ) {
                return 1;
            }
            else {
                if (nowy) {
                     wiktor::dodaj(wiktor::dlugosc[pierwszy]);
                    for (int i = 0; i < min(wiktor::dlugosc[pierwszy],wiktor::dlugosc[drugi]); i++){
                        wiktor::wektor[wiktor::ilosc][i] = wiktor::wektor[pierwszy][i] - wiktor::wektor[drugi][i];
                    }
                    for (int i = min(wiktor::dlugosc[pierwszy],wiktor::dlugosc[drugi]); i <  wiktor::dlugosc[pierwszy]; i++) {
                        wiktor::wektor[wiktor::ilosc][i] = wiktor::wektor[pierwszy][i];
                    }
                }
                else {
                    for (int i = 0; i < min(wiktor::dlugosc[pierwszy],wiktor::dlugosc[drugi]); i++){
                        wiktor::wektor[pierwszy][i] = wiktor::wektor[pierwszy][i] - wiktor::wektor[drugi][i];
                    }
                }
                return 0;
            }
        }

};

char interface() {   // funkcja generujca interface
    clrscr();
    cout << name << " v." << version << "." << subversion << " (C) 2005" << endl << endl;
    cout << "w - Wyswietl biezace wektory" << endl;
    cout << "1 - Dodaj wektor" << endl;
    cout << "c - Wyczysc wektor" << endl;
    cout << "u - Usun wektor" << endl;
    cout << "e - Zmien Element" << endl;
    cout << "z - Zmien caly" << endl;
    cout << "r - Zmien Rozmiar" << endl;
    cout << "s - Podaj Rozmiar" << endl;
    cout << "d - Zwroc element" << endl;
    cout << "a - Suma Wektorow" << endl;
    cout << "o - Roznica wektorow" << endl;
    cout << "p - Pomnoz przez skalar" << endl;
    cout << "i - Pomnoz wektory skalarnie" << endl;
    cout << "l - Utwoz losowo wektory" << endl;
    cout << "? - Pomoc & Info" << endl;
    cout << "X - Wyjdz z programu" << endl;
    return getch();
}



int main(void)
{
    bool exit = false;
    wiktor w1;

    do { //ptla programu
       switch ( char cha = tolower(interface()) ) {
            case 'w' :
                clrscr();
                cout << "[" << cha << "] Wyswietl biezace wektory" << endl << endl ;
                w1.wyswietl();
                getch();
                break;
            case '1' :
                clrscr();
                cout << "[" << cha << "] Dodaj Wektor" << endl << endl ;
                int dlugosc;
                do {
                    cout << "Podaj dlugosc wektora : ";
                    cin >> dlugosc;
                    if (dlugosc < 1 || dlugosc >= dl_max)
                        cout << "Blad danych! (za duzy wektor)" << endl;
                } while (dlugosc < 1 || dlugosc >= dl_max);
                cout << endl;
                w1.dodaj(dlugosc);
                w1.wyswietl();
                getch();
                break;
            case 'c' :
                clrscr();
                cout << "[" << cha << "] Wyczysc Wektor" << endl << endl ;
                if (!w1.wyswietl()) {
                    int ktory;
                    cout << endl << "Ktory wektor chcesz wyczyscic : ";
                    cin >> ktory;
                    cout << endl;
                    if (w1.wymaz(ktory))
                        cout << "Blad danych! (Wektor nie istnieje)" << endl;
                    w1.wyswietl();
                }
                getch();
                break;
            case 'u' :
                clrscr();
                cout << "[" << cha << "] Usun Wektor" << endl << endl ;
                if (!w1.wyswietl()) {
                    int ktory;
                    cout << endl << "Ktory wektor chcesz usunac : ";
                    cin >> ktory;
                    cout << endl;
                    if (w1.usun(ktory))
                        cout << "Blad danych! (Wektor nie istnieje)" << endl;
                    w1.wyswietl();
                }
                getch();
                break;
            case 'e' :
                clrscr();
                cout << "[" << cha << "] Wpisz Element" << endl << endl ;
                if (!w1.wyswietl()) {
                    int ktory_wektor, ktory_element, wartosc;
                    cout << endl << "Element ktorego wektora chcesz zmienic : ";
                    cin >> ktory_wektor;
                    cout << "Ktory element " << ktory_wektor << " wektora chcesz zmienic : ";
                    cin >> ktory_element;
                    cout << "Podaj nowa wartosc " << ktory_element << " elementu " << ktory_wektor << " wektora : ";
                    cin >> wartosc;
                    if (w1.wpisz_element(ktory_wektor, ktory_element, wartosc)) {
                        cout << endl << "Blad danych! (Wektor lub element nie istnieje)";
                    }
                    else {
                        cout << endl << "Wartosc zostala zmieniona!" << endl << endl;
                        w1.wyswietl();
                    }
                }
                getch();
                break;
            case 'z' :
                clrscr();
                cout << "[" << cha << "] Wpisz Caly" << endl << endl ;
                if (!w1.wyswietl()) {
                    int ktory_wektor, rozmiar, wartosc;

                    cout << endl << "Elementy ktorego wektora chcesz zmienic : ";
                    cin >> ktory_wektor;

                    if (w1.zwroc_rozmiar(ktory_wektor))
                    {
                        for (int i = 0; i < w1.zwroc_rozmiar(ktory_wektor); i++) {
                            cout << "Podaj nowa wartosc " << i << " elementu " << ktory_wektor << " wektora :";
                            cin >> wartosc;
                            w1.wpisz_element(ktory_wektor, i, wartosc);
                        }
                        cout << endl << "Wartosci zostaly zmienione!" << endl << endl;
                        w1.wyswietl();
                    }
                    else {
                        cout << endl << "Blad danych! (Wektor nie istnieje)";
                    }
                }
                getch();
                break;
            case 'r' :
                clrscr();
                cout << "[" << cha << "] Zmien Rozmiar" << endl << endl ;
                if (!w1.wyswietl()) {
                    int ktory, nowy_rozmiar;
                    cout << endl << "Rozmiar ktorego wektora chcesz zmienic : ";
                    cin >> ktory;
                    cout << "Podaj nowy rozmiar " << ktory << " wektora : ";
                    cin >> nowy_rozmiar;
                    cout << endl;

                    if (w1.zmien_rozmiar(ktory, nowy_rozmiar))
                        cout << endl << "Blad danych! (Wektor nie istnieje, lub za duza dlugosc)";
                    else
                        w1.wyswietl();
                }

                getch();
                break;
            case 's' :
                clrscr();
                cout << "[" << cha << "] Rozmiar wektora" << endl << endl ;
                if (!w1.wyswietl()) {
                    int ktory;
                    cout << endl << "Rozmiar ktorego wektora : ";
                    cin >> ktory;
                    cout << endl;
                    if ( int rozmiar = w1.zwroc_rozmiar(ktory) )
                        cout << "Rozmiar wektora " << ktory << " wynosi : " << rozmiar << endl;
                    else
                        cout << "Blad danych! (Wektor nie istnieje)" << endl;
                }
                getch();
                break;
            case 'd' :
                clrscr();
                cout << "[" << cha << "] Zwroc Element" << endl << endl ;
                if (!w1.wyswietl()) {
                    int ktory, element;
                    cout << endl << "Element ktorego wektora chcesz dostac : ";
                    cin >> ktory;
                    cout << "Wartosc ktorego elementu " << ktory << " wektora : ";
                    cin >> element;
                    cout << endl;

                    try {
                        cout << element << " element " << ktory << " wektora ma wartosc : " << w1.zwroc_element(ktory, element) << endl;
                    }
                    catch(int i) {
                        cout << "Blad danych! (Wektor lub element nie istnieje)" << endl;
                    }
                }
                getch();
                break;
            case 'p' :
                clrscr();
                cout << "[" << cha << "] Pomnoz wektor przez skalar" << endl << endl ;
                if (!w1.wyswietl()) {
                    int ktory, ile;
                    cout << endl << "Ktory wektor chcesz pomnozyc : ";
                    cin >> ktory;
                    cout << "O jaka wartosc chcesz pomnozyc wektor " << ktory << " ? : ";
                    cin >> ile;
                    cout << endl;

                    if (!w1.razy_skalar(ktory, ile))
                        w1.wyswietl();
                    else
                        cout << "Blad danych! (Wektor lub element nie istnieje)" << endl;
                }
                getch();
                break;
            case 'a' :
                clrscr();
                cout << "[" << cha << "] Suma wektorw" << endl << endl ;
                if (!w1.wyswietl()) {
                    int pierwszy, drugi, cha;
                    bool nowy;
                    cout << endl << "Podaj pierwszy skadnik : ";
                    cin >> pierwszy;
                    cout << "Podaj drugi skadnik [" << pierwszy << "]+?? : ";
                    cin >> drugi;
                    cout << "utworzyc nowy wektor? [T/N]: ";
                    do
                    {
                        cha = getch();
                    }
                    while ( tolower(cha) != 't' && tolower(cha) != 'n');
                    tolower(cha) == 'n'? nowy = 0 : nowy = 1 ;
                    cout << endl;


                    if (w1.dodaj_dwa(pierwszy, drugi, nowy)) {
                        cout << "Blad danych! (Wektory nie istnieja)" << endl;
                    }
                    else {

                        w1.wyswietl();
                    }
                }
                getch();
                break;
            case 'o' :
                clrscr();
                cout << "[" << cha << "] Roznica wektorw" << endl << endl ;
                if (!w1.wyswietl()) {
                    int pierwszy, drugi;
                    bool nowy;
                    cout << endl << "Podaj odjemnik : ";
                    cin >> pierwszy;
                    cout << "Podaj odjemna [" << pierwszy << "]-?? : ";
                    cin >> drugi;
                    cout << "utworzyc nowy wektor? [T/N]: ";
                    do
                    {
                        cha = getch();
                    }
                    while ( tolower(cha) != 't' && tolower(cha) != 'n');
                    tolower(cha) == 'n'? nowy = 0 : nowy = 1 ;
                    cout << endl;


                    if (w1.odejmij_dwa(pierwszy, drugi, nowy)) {
                        cout << "Blad danych! (Wektory nie istnieja)" << endl;
                    }
                    else {

                        w1.wyswietl();
                    }
                }
                getch();
                break;
            case 'i' :
                clrscr();
                cout << "[" << cha << "] Iloczyn skalarny wektorow" << endl << endl ;
                if (!w1.wyswietl()) {
                    int pierwszy, drugi;
                    bool nowy;
                    cout << endl << "Podaj pierwszy czynnik : ";
                    cin >> pierwszy;
                    cout << "Podaj drugi czynnik [" << pierwszy << "]*?? : ";
                    cin >> drugi;
                    cout << endl;
                    try {
                        cout << "Iloczyn skalarny wynosi : " << w1.iloczyn_ska(pierwszy, drugi);
                    }
                    catch(int i) {
                        cout << "Blad Danych! (Wektory nie istnieja, lub maja rozne wymiary)";
                    }
                }
                getch();
                break;
            case 'l' :
                clrscr();
                cout << "[" << cha << "] Utwoz losowo wektory" << endl << endl ;

                int min, max, ile;
                cout << endl << "Ile wektorow chcesz utworzyc? : ";
                cin >> ile;
                cout << "Minimalny Rozmiar : ";
                cin >> min;
                cout << "Maksymalny rozmiar : ";
                cin >> max;

                if ( min > max ) {
                    cout << "Blad danych! (ujemny wspolczynnik)";
                }
                else {
                    randomize();
                    for (int i = 0; i<ile; i++)
                        w1.dodaj(random(max - min) + min);

                    w1.wyswietl();
                }
                getch();
                break;
            case '+' :
                clrscr();
                cout << "[" << cha << "] " << endl << endl ;
                if (!w1.wyswietl()) {
                    int pierwszy = 0, drugi;
                    if ( pierwszy ) {
                        w1.wyswietl();
                    }
                }
                getch();
                break;
            case '?' :
            case '/' :
                clrscr();
                cout << "[?] Pomoc & Info" << endl << endl ;
                cout << "Program Wykonali: " << endl << endl;
                cout << "Karol Kozlowski (132652@student.pwr.wroc.pl)" << endl;
                cout << "Karol Nikscin   (132750@student.pwr.wroc.pl)" << endl;
                getch();
                break;
            case 'q':
            case 'x':
            case 27 :
                cout << "EXIT";
                exit = true;
                break;
            default :
                cout << endl << "Wybor niepoprawny, badz funkcja nie zostala zaimplementowana!" << endl;
                getch();
        }
    } while (!exit);

    return 0;
}
//EOF
